#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "maxheap.h"

/* O que eu mudei:
- coloquei o struct maxheap no maxheap.h (para que o usuario possa acessar), 
entretanto isso naum eh uma boa pratica de encapsulamento
- Agora a capacidade eh recebida como parametro na criacao do maxheap
- Adicionei alguns comentarios e alguma formatacao
*/

int pai(int i){return ceil(i/2.0)-1;}
int esq(int i){return 2*i+1;}
int dir(int i){return 2*i+2;}

maxheap* cria_maxheap(int cap){
  maxheap* H = (maxheap*) malloc(sizeof(maxheap));
  H->n = 0;
  H->capacidade = cap;
  H->V = (int*) malloc(sizeof(int) * H->capacidade);
  return H;
}

void sobe_maxheap(maxheap *H, int i){
  if(i == 0) return;
  int p = pai(i);
  if(H->V[p] < H->V[i]){
    //se o pai é menor que o filho
    int aux = H->V[p];
    H->V[p] = H->V[i];
    H->V[i] = aux;
    sobe_maxheap(H, p);
  }
  return;
}

void desce_maxheap(maxheap *H, int i){
  int e = esq(i);
  int d = dir(i);
  
  //se naum tem filho esquerdo, entao naum tem nenhum filho, jah eh folha 
  //naum precisa descer mais
  if(e >= H->n) return;

  int imaior = e; //indice do maior filho supomos que eh o esquerdo e se nao for trocamos abaixo
  
  //se o direito existe e é maior que o esq
  if(d < H->n && H->V[d] > H->V[e]){
    imaior = d;
  }
  
  if(H->V[i] < H->V[imaior]){
    //se o i é menor que o maior filho
    // se for precisa descer
    int aux = H->V[i];
    H->V[i] = H->V[imaior];
    H->V[imaior] = aux;
    desce_maxheap(H, imaior);
  }
  return;  
}

void insere_max(maxheap * H, int v){
  H->V[H->n] = v;
  H->n = H->n + 1;
  sobe_maxheap(H, H->n - 1);
}

void imprime_maxheap(maxheap *H){
  for(int i = 0; i < H->n; i++){
    printf("%d, ", H->V[i]);
  }
  printf("\n");
}

void constroi_maxheap(maxheap *H){
  //TODO
}


int remove_max(maxheap * H){
  int maior = H->V[0];
  H->n = H->n - 1;
  H->V[0] = H->V[H->n];
  desce_maxheap(H, 0);
  return maior;
}


void libera_maxheap(maxheap* H){
  free(H->V);
  free(H);
}















